import matplotlib.pyplot as plt
import numpy as np

x = ["A", "B", "C"]
y = [93.60, 94.20, 98.00]


#### accuracy comparisions between same model focus on different methods

fig, ax = plt.subplots(figsize=(10, 7))
ax.bar(
    x=x,  # x label
    height=y,  # height
    width=0.5,  # weight
    align="center",  # 'center' or 'edge'
    color="red",  
    edgecolor="black",  
    linewidth=2.0  
ax.set_title("60dB MLP classification accuracy comparsions", fontsize=15)
ax.set_ylabel('Accuracy (%)', fontsize=15)

xticks = ax.get_xticks()
for i in range(len(y)):
    xy = (xticks[i], y[i] * 1.03)
    s = str(y[i])
    ax.annotate(
        s=s,  
        xy=xy,  
        fontsize=12,  
        color="black",  
        ha="center",  
        va="baseline"  
    )
    

#### Recall comparisions

plt.figure(figsize=(10, 8))
list_00 = [99.46, 99.71, 100]
list_01 = [91.29, 89.83, 97.55]
list_02 = [88.93, 92.88, 96.42]
#list_03 = [0.04, 0.13, 0.19, 0.15]
name_list = ['A', 'B', 'C']
x = list(range(len(name_list)))
total_width, n = 0.8, 3
width = total_width / n
p1=plt.bar(x, list_00, width=width, label='Undamaged', tick_label=name_list, fc='g')
plt.bar_label(p1, label_type='edge')
#plt.bar_label(list_00,fmt='%g%%')
for i in range(len(x)):
    x[i] = x[i] + width
p2=plt.bar(x, list_01, width=width, label='Low Damage', fc='r')
plt.bar_label(p2, label_type='edge')
for i in range(len(x)):
    x[i] = x[i] + width
p3=plt.bar(x, list_02, width=width, label='High Damage', fc='b')
plt.bar_label(p3, label_type='edge')
for i in range(len(x)):
    x[i] = x[i] + width
#plt.bar(x, list_03, width=width, label='d', fc='g')
plt.legend(loc='lower right', fontsize=15)
plt.ylabel("Recall (%)",fontsize=15)
plt.title("60dB MLP classification Recall comparsions", fontsize=15)
plt.show()

#### Precision comparisions

import matplotlib.pyplot as plt
plt.figure(figsize=(10, 8))
list_00 = [95.57, 96.11, 94.94]
list_01 = [91.29, 94.50, 99.69]
list_02 = [93.64, 91.69, 98.00]
#list_03 = [0.04, 0.13, 0.19, 0.15]
name_list = ['A', 'B', 'C']
x = list(range(len(name_list)))
total_width, n = 0.8, 3
width = total_width / n
p1=plt.bar(x, list_00, width=width, label='Undamaged', tick_label=name_list, fc='g')
plt.bar_label(p1, label_type='edge')
#plt.bar_label(list_00,fmt='%g%%')
for i in range(len(x)):
    x[i] = x[i] + width
p2=plt.bar(x, list_01, width=width, label='Low Damage', fc='r')
plt.bar_label(p2, label_type='edge')
for i in range(len(x)):
    x[i] = x[i] + width
p3=plt.bar(x, list_02, width=width, label='High Damage', fc='b')
plt.bar_label(p3, label_type='edge')
for i in range(len(x)):
    x[i] = x[i] + width
#plt.bar(x, list_03, width=width, label='d', fc='g')
plt.legend(loc='lower right', fontsize=15) # 标签位置
plt.ylabel("Precision (%)",fontsize=15)
plt.title("60dB MLP classification Precision comparsions", fontsize=15)
plt.show()


##### accuracy comparisions between different models

import matplotlib.pyplot as plt
plt.figure(figsize=(10, 8))
list_00 = [93.60, 94.20, 98.00]
list_01 = [85.50, 87.20, 98.60]
#list_02 = [90.80, 91.00, 96.84]
#list_03 = [0.04, 0.13, 0.19, 0.15]
name_list = ['A', 'B', 'C']
x = list(range(len(name_list)))
total_width, n = 0.8, 3
width = total_width / n
p1=plt.bar(x, list_00, width=width, label='MLP', tick_label=name_list, fc='r')
plt.bar_label(p1, label_type='edge')
#plt.bar_label(list_00,fmt='%g%%')
for i in range(len(x)):
    x[i] = x[i] + width
p2=plt.bar(x, list_01, width=width, label='CNN', fc='b')
plt.bar_label(p2, label_type='edge')
for i in range(len(x)):
    x[i] = x[i] + width
#p3=plt.bar(x, list_02, width=width, label='60dB', fc='b')
#plt.bar_label(p3, label_type='edge')
for i in range(len(x)):
    x[i] = x[i] + width
#plt.bar(x, list_03, width=width, label='d', fc='g')
plt.title("60dB models Accuracy comparsions", fontsize=15)
plt.legend(loc='lower right', fontsize=15) # 
plt.ylabel("Accuracy (%)",fontsize=15)
plt.show()

#### accuracy comparisions between same model focus on noise effect

import matplotlib.pyplot as plt
plt.figure(figsize=(10, 8))
list_00 = [82.80,91.40, 97.80]
list_01 = [86.50, 88.80, 97.80]
list_02 = [85.50, 87.20, 98.60]
#list_03 = [0.04, 0.13, 0.19, 0.15]
name_list = ['A', 'B', 'C']
x = list(range(len(name_list)))
total_width, n = 0.8, 3
width = total_width / n
p1=plt.bar(x, list_00, width=width, label='20dB', tick_label=name_list, fc='g')
plt.bar_label(p1, label_type='edge')
#plt.bar_label(list_00,fmt='%g%%')
for i in range(len(x)):
    x[i] = x[i] + width
p2=plt.bar(x, list_01, width=width, label='40dB', fc='r')
plt.bar_label(p2, label_type='edge')
for i in range(len(x)):
    x[i] = x[i] + width
p3=plt.bar(x, list_02, width=width, label='60dB', fc='b')
plt.bar_label(p3, label_type='edge')
for i in range(len(x)):
    x[i] = x[i] + width
#plt.bar(x, list_03, width=width, label='d', fc='g')
plt.legend(loc='lower right', fontsize=15)
plt.ylabel("Accuracy (%)",fontsize=15)
plt.title("Noise effect of accuracy on CNN models", fontsize=15)
plt.show()

###Accuracy on different SNR levels of the best model trained from 20dB noise level

import matplotlib.pyplot as plt
plt.figure(figsize=(10, 8))
list_00 = [82.80,91.40, 97.80]
list_01 = [81.80,90.70, 98.20]
list_02 = [80.50, 89.30, 97.80]
#list_03 = [0.04, 0.13, 0.19, 0.15]
name_list = ['A', 'B', 'C']
x = list(range(len(name_list)))
total_width, n = 0.8, 3
width = total_width / n
p1=plt.bar(x, list_00, width=width, label='Trained -20dB', tick_label=name_list, fc='r')
plt.bar_label(p1, label_type='edge')
#plt.bar_label(list_00,fmt='%g%%')
for i in range(len(x)):
    x[i] = x[i] + width
p2=plt.bar(x, list_01, width=width, label='40dB', fc='g')
plt.bar_label(p2, label_type='edge')
for i in range(len(x)):
    x[i] = x[i] + width
p3=plt.bar(x, list_02, width=width, label='60dB', fc='b')
plt.bar_label(p3, label_type='edge')
for i in range(len(x)):
    x[i] = x[i] + width
#plt.bar(x, list_03, width=width, label='d', fc='g')
plt.legend(loc='lower right', fontsize=15) # 标签位置
plt.ylabel("Accuracy (%)",fontsize=15)
plt.title("Accuracy on different SNR levels of the best model trained from 20dB noise level", fontsize=15)
plt.show()